#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Arduino.h>
#include <Wire.h>

// ---- PIN CONFIG ----
#define BTN_UP    2
#define BTN_DOWN  3
#define BTN_LEFT  4
#define BTN_RIGHT 5
#define SDA_PIN 6
#define SCL_PIN 7
#define BUZZER_PIN 8

// ---- DISPLAY CONFIG ----
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1
#define OLED_ADDR 0x3C

// buzzer test frequencies
u_int32_t Frequencies[] = {400,800,1600,3200,6400,10000,20000};
uint32_t chosen_Freq = 0;
bool Started = false;

Adafruit_SSD1306 display(OLED_RESET);

// buzzer test display
void DisplayRenderer() {
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(43, 0);
  display.println(String(Frequencies[chosen_Freq])+"Hz");
  display.setCursor(16, 23);
  display.println("+");
  display.setCursor(50, 23);
  if (Started) {
    display.println("Stop");
  }
  else {
    display.println("Start");
  }
  display.setCursor(97, 23);
  display.println("-");
  display.display();
}

void setup() 
{
  Serial.begin(115200);
  Serial.println("Hello World");

  pinMode(BTN_UP, INPUT);
  pinMode(BTN_LEFT, INPUT);
  pinMode(BTN_RIGHT, INPUT);

  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(43, 0);
  display.println(String(Frequencies[chosen_Freq])+"Hz");
  display.setCursor(16, 23);
  display.println("+");
  display.setCursor(50, 23);
  display.println("Start");
  display.setCursor(97, 23);
  display.println("-");
  display.display();
}

void loop() {
  if (digitalRead(BTN_UP) == HIGH) {
    if (Started) {
      noTone(BUZZER_PIN);
      Started = false;
    }
    else {
      tone(BUZZER_PIN, Frequencies[chosen_Freq]);
      Started = true;
    }
    DisplayRenderer();
    delay(150);
  }
  if (digitalRead(BTN_LEFT) == HIGH)
  {
    if (chosen_Freq < 6) {
      chosen_Freq++;
      if (Started) {
        tone(BUZZER_PIN, Frequencies[chosen_Freq]);
      }
    }
    DisplayRenderer();
    delay(150);
  }
  if (digitalRead(BTN_RIGHT) == HIGH) {
    if (chosen_Freq > 0 ) {
      chosen_Freq--;
      if (Started) {
        tone(BUZZER_PIN, Frequencies[chosen_Freq]);
      }
    }
    DisplayRenderer();
    delay(150);
  }
}